unit Main;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Spin, Buttons, Menus, ComCtrls, ExtCtrls,
  Grids, HRTimer, mmsystem;

type
  TForm1 = class(TForm)
    TrackBar1: TTrackBar;
    Timer1: TTimer;
    TrackBar2: TTrackBar;
    TrackBar3: TTrackBar;
    TrackBar4: TTrackBar;
    Label3: TLabel;
    Label4: TLabel;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Help1: TMenuItem;
    Load1: TMenuItem;
    Saveas1: TMenuItem;
    Quit1: TMenuItem;
    About1: TMenuItem;
    Help2: TMenuItem;
    Options1: TMenuItem;
    Calibrate1: TMenuItem;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    StringGrid1: TStringGrid;
    EditButton: TSpeedButton;
    AddButton: TButton;
    Label9: TLabel;
    PlayLastButton: TButton;
    PlaySpeed: TSpeedButton;
    Label2: TLabel;
    Label1: TLabel;
    SpinEdit1: TSpinEdit;
    SpinEdit2: TSpinEdit;
    StickBox1: TCheckBox;
    disableservocheck: TCheckBox;
    procedure TrackBar1Change(Sender: TObject);
    procedure updateservo;
    procedure Timer1Timer(Sender: TObject);
    procedure PlayButtonClick(Sender: TObject);
    procedure Quit1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure Help2Click(Sender: TObject);
    procedure Load1Click(Sender: TObject);
    procedure Saveas1Click(Sender: TObject);
    procedure Calibrate1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure AddButtonClick(Sender: TObject);
    procedure PlaySpeedClick(Sender: TObject);
    procedure PlayLastButtonClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure Button1MouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure SpinEdit1Change(Sender: TObject);
    procedure SpinEdit2Change(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  CorrectionValue : integer;
  intervalle : integer;
  HRT : THRTimer;
  playing : boolean;
implementation

uses aboutboxunit, calibrationunit;

{uses Unit1;}

{$R *.DFM}


procedure outvalue(value : smallint);
begin
asm
mov dx,0378h
mov ax,value
out dx,al
mov dx,037ah
mov al,00000001b
out dx,al
mov dx,037ah
mov al,00000000b
out dx,al
end;
end;

procedure delay(value : integer);
begin
HRT.StartTimer;  {Resets the timer to zero}
repeat
until hrt.readtimer*1000 > value
end;

procedure loresdelay(value : integer);
var FirstTickCount : longint;
begin
FirstTickCount:=GettickCount;
repeat
Application.ProcessMessages;
until((getTickCount-FirstTickCount)>= Longint(value));
end;




procedure saveto(filenam : string);
var
  F: TextFile;
  x,y : byte;
begin
AssignFile(F,filenam);   { File selected in dialog box }
Rewrite(F);
for y:= 0 to 15 do
 begin
   for x:= 0 to 3 do
    begin
    writeln(F,form1.stringgrid1.cells[x,y]);
{    write(F,' ');}
    end;
{    writeln(F,'');}
  end;
CloseFile(F);
end;

procedure filopen(filenam : string);
var
  F: TextFile;
  x,y : byte;
  dummy : string;
begin
AssignFile(F,filenam);   { File selected in dialog box }
Reset(F);
for y:= 0 to 15 do
for x:= 0 to 3 do
     begin
     readln(F,dummy);
     form1.stringgrid1.cells[x,y]:=dummy;
     end;

CloseFile(F);
end;



procedure TForm1.updateservo; {every 18 - 20 msec : see timer}
var  myjoy: tjoyinfo;
begin
if disableservocheck.checked then exit;

if stickbox1.checked then
begin
  joygetpos(joystickid1,@myjoy);
  trackbar1.position :=trackbar1.min+(trackbar1.max-trackbar1.min)* myjoy.wypos div 65000;
  trackbar2.position :=trackbar2.min+(trackbar2.max-trackbar2.min)* myjoy.wxpos div 65000;
end;

outvalue(1); {on}
delay(trackbar1.position*10);
outvalue(0);   {off}

outvalue(2); {on}
delay(trackbar2.position*10);
outvalue(0);   {off}

outvalue(4); {on}
delay(trackbar3.position*10);
outvalue(0);   {off}

outvalue(8); {on}
delay(trackbar4.position*10);
outvalue(0);   {off}

end;



procedure TForm1.TrackBar1Change(Sender: TObject);
begin

if sender = trackbar1  then
begin
label1.caption:=inttostr(trackbar1.position);
if editbutton.down then
stringgrid1.cells[0,stringgrid1.row]:=inttostr(trackbar1.position);
end;

if sender = trackbar2  then
begin
label2.caption:=inttostr(trackbar2.position);
if editbutton.down then
stringgrid1.cells[1,stringgrid1.row]:=inttostr(trackbar2.position);
end;

if sender = trackbar3  then
begin
label3.caption:=inttostr(trackbar3.position);
if editbutton.down then
stringgrid1.cells[2,stringgrid1.row]:=inttostr(trackbar3.position);
end;

if sender = trackbar4  then
begin
label4.caption:=inttostr(trackbar4.position);
if editbutton.down then
stringgrid1.cells[3,stringgrid1.row]:=inttostr(trackbar4.position);
end;

end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
updateservo;

end;

procedure TForm1.PlayButtonClick(Sender: TObject);
var y : integer;
begin
stringgrid1.Row:=0;
 for y:=0 to 15 do
 begin
 trackbar1.position:=strtoint(stringgrid1.cells[0,y]);
 trackbar2.position:=strtoint(stringgrid1.cells[1,y]);
 trackbar3.position:=strtoint(stringgrid1.cells[2,y]);
 trackbar4.position:=strtoint(stringgrid1.cells[3,y]);

 delay(1000);
 end;
end;






procedure TForm1.Quit1Click(Sender: TObject);
begin
application.terminate;
end;

procedure TForm1.About1Click(Sender: TObject);
begin
aboutbox.show;
end;

procedure TForm1.Help2Click(Sender: TObject);
begin
MessageDlg('Help not yet implemented', mtinformation,[mbok],1);
end;

procedure TForm1.Load1Click(Sender: TObject);
begin
if opendialog1.execute then
filopen(opendialog1.filename);
end;

procedure TForm1.Saveas1Click(Sender: TObject);
begin
if savedialog1.execute then
  begin
  saveto(savedialog1.FileName)
  end;

end;




procedure TForm1.Calibrate1Click(Sender: TObject);
begin
calibrationbox.show;
end;

procedure TForm1.Button2Click(Sender: TObject);
var x,y : byte;
begin
for x:=0 to 3 do
for y:=0 to 15 do
begin
stringgrid1.Cells[x,y]:=inttostr(random(200));

end;
end;

procedure TForm1.FormCreate(Sender: TObject);
begin
HRT := THRTimer.Create;
playing:=false;
{initialize trackbar minimun, followind spinedit 's :}
trackbar1.min:=spinedit1.value;
trackbar2.min:=spinedit1.value;
trackbar3.min:=spinedit1.value;
trackbar4.min:=spinedit1.value;

{initialize trackbar maximum, followind spinedit 's :}
trackbar1.max:=spinedit2.value;
trackbar2.max:=spinedit2.value;
trackbar3.max:=spinedit2.value;
trackbar4.max:=spinedit2.value;


{center the trackbar's and thus the servo :}
trackbar1.position:=trackbar1.Min + ((trackbar1.Max-trackbar1.Min) div 2);
trackbar2.position:=trackbar2.Min + ((trackbar2.Max-trackbar2.Min) div 2);
trackbar3.position:=trackbar3.Min + ((trackbar3.Max-trackbar3.Min) div 2);
trackbar4.position:=trackbar4.Min + ((trackbar4.Max-trackbar4.Min) div 2);
end;


procedure TForm1.Button3Click(Sender: TObject);
begin
stringgrid1.Row:=stringgrid1.row + 1;
end;


procedure TForm1.AddButtonClick(Sender: TObject);
begin
stringgrid1.cells[0,stringgrid1.Row]:=inttostr(trackbar1.position);
stringgrid1.cells[1,stringgrid1.Row]:=inttostr(trackbar2.position);
stringgrid1.cells[2,stringgrid1.Row]:=inttostr(trackbar3.position);
stringgrid1.cells[3,stringgrid1.Row]:=inttostr(trackbar4.position);
stringgrid1.Row:=stringgrid1.Row + 1;
end;

procedure TForm1.PlaySpeedClick(Sender: TObject);
var y : integer;
begin
playing:= not playing;
if playing then playspeed.caption:='Stop';
if not playing then playspeed.caption:='Play';

if not playing then exit;
stringgrid1.Row:=0;
 for y:=0 to 15 do
 begin
      if stringgrid1.cells[0,y]='' then
       begin
       playing:=false;
       playspeed.caption:='Play';
       exit;
       end;
 StickBox1.checked:=false;
 stringgrid1.row:=y;
 trackbar1.position:=strtoint(stringgrid1.cells[0,y]);
 trackbar2.position:=strtoint(stringgrid1.cells[1,y]);
 trackbar3.position:=strtoint(stringgrid1.cells[2,y]);
 trackbar4.position:=strtoint(stringgrid1.cells[3,y]);
 updateservo;
 if not playing then exit;
 loresdelay(1000);
 end;
end;


procedure TForm1.PlayLastButtonClick(Sender: TObject);
begin
  if stringgrid1.cells[0,stringgrid1.row]='' then exit;


trackbar1.position:=strtoint(stringgrid1.cells[0,stringgrid1.row]);
trackbar2.position:=strtoint(stringgrid1.cells[1,stringgrid1.row]);
trackbar3.position:=strtoint(stringgrid1.cells[2,stringgrid1.row]);
trackbar4.position:=strtoint(stringgrid1.cells[3,stringgrid1.row]);

end;



procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
HRT.Free;
end;

procedure TForm1.Button1MouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var pol : double;
begin
   pol:=HRT.ReadTimer;   {Returns the elapsed time in milliseconds since the time start}
   ShowMessage(floattostr(pol));

end;

procedure TForm1.Button1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   HRT.StartTimer;  {Resets the timer to zero}
end;

procedure TForm1.SpinEdit1Change(Sender: TObject);
begin
trackbar1.min:=spinedit1.value;
trackbar2.min:=spinedit1.value;
trackbar3.min:=spinedit1.value;
trackbar4.min:=spinedit1.value;
end;

procedure TForm1.SpinEdit2Change(Sender: TObject);
begin
trackbar1.max:=spinedit2.value;
trackbar2.max:=spinedit2.value;
trackbar3.max:=spinedit2.value;
trackbar4.max:=spinedit2.value;
end;

end.
